﻿/*
Release date: March 12th 2014

Author: Josip

Description: 
On enter (new line) match the indent of the previous line, auto insert markdown bullets and increment 
numbers.

Instalation:
Unzip the "Auto indent" directory into the plugins directory.

Deployment:
This plugin is initialized at startup. Use CTRL+E,I to toggle plugin on / off. SHIFT+ENTER will bypass 
auto indent functionality.
*/


var shortcutKey = "I";
var pluginActive = true;
var autoIndentOnS = "Auto indent on";
var autoIndentOffS = "Auto indent off";

monkey.add_keyDownE(function(object, eventargs) {

	// One level down if shift + enter
	if (eventargs.KeyCode == System.Windows.Forms.Keys.Enter && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Shift && pluginActive) {
		eventargs.SuppressKeyPress = true;
		eventargs.Handled = true;
		insertIndentedNewLine(-1);
	}
	// One level up if ctrl+enter
	else if (eventargs.KeyCode == System.Windows.Forms.Keys.Enter && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control && pluginActive) {
		eventargs.SuppressKeyPress = true;
		eventargs.Handled = true;
		insertIndentedNewLine(1);
	}
	// Same level if enter
	else if (eventargs.KeyCode == System.Windows.Forms.Keys.Enter && pluginActive) {
		eventargs.SuppressKeyPress = true;
		eventargs.Handled = true;
		insertIndentedNewLine(0);
	}
});

// Toggle on / off
monkey.add_extendedShortcutFiredE(function(object, eventargs) {
	if (eventargs.extendedKey == shortcutKey) {
		toggleAutoInsert();
	}
});

function toggleAutoInsert() {
	if (pluginActive) {
		pluginActive = false;
		monkey.showNotice(autoIndentOffS, true, false);
	}
	else {
		pluginActive = true;
		monkey.showNotice(autoIndentOnS, true, false);
	}
};

function insertIndentedNewLine(level) { // 0 = same, 1 = up, -1 = down
	var currPara = monkey.text.substring(monkey.paragraphUnderCaretStart, monkey.paragraphUnderCaretEnd);

	var regex = "^(\\s*)(\\*|\\+|-|[0-9]+\\.{1})*( {1,})(\\S+)*";
	var match = System.Text.RegularExpressions.Regex.Match(currPara, regex, System.Text.RegularExpressions.RegexOptions.Compiled);

	// Stop auto bullets / numbers
	if ((match.Groups[4].Value == "" && match.Groups[2].Value != "") || monkey.paragraphUnderCaretStart == monkey.selectionStart) {
		monkey.select(monkey.paragraphUnderCaretStart, monkey.selectionStart - monkey.paragraphUnderCaretStart);
		monkey.selectedText = "\n"; // or   match.Groups[1].Value   if you want to preserve the left indent
		return;
	}

	var group1 = match.Groups[1].Value;
	if (level == -1) {
		group1 = group1.replace("\t", "");
	}

	// Increment number in group 2 if it is there
	var group2 = match.Groups[2].Value;
	var num = System.Text.RegularExpressions.Regex.Match(match.Groups[2].Value, "[0-9]+", System.Text.RegularExpressions.RegexOptions.Compiled);
	if (num.Success) {
		group2 = System.Text.RegularExpressions.Regex.Replace(match.Groups[2].Value, "[0-9]+", parseInt(num.Value) + 1);
	}

	// Add prepended new line
	monkey.selectedText = "\n" + ((level == 1) ? "\t" : "") + group1.replace("\n", "") + group2 + match.Groups[3].Value;
};
